var limit = 100;
var offset = 0;

function loadMeasurementValues(extendList) {
  var newLimit = 0;

  if (extendList !== undefined && extendList === false) {
    // the number of all the shown rows
    newLimit = offset + limit;
    offset = 0;
    clearChartData();
  } else {
    newLimit = limit;
  }

  var measurementId = $('#measurement_id').val();

  $.ajax({
    url : baseUrl + 'measurementvalue/get_json/' + measurementId + '/' + offset + '/' + newLimit,
    cache : false
  }).done(function(data) {
    var tablerows = '';

    data.forEach(function(m_value) {
      tablerows += '<tr class="mValRow">';
      tablerows += '<td>' + m_value['Timestamp'] + '</td>';
      tablerows += '<td>' + m_value['ErtekA'] + '</td>';
      tablerows += '<td>' + m_value['ErtekB'] + '</td>';
      tablerows += '<td>' + m_value['ErtekC'] + '</td>';
      tablerows += '<td><button type="submit" class="btn btn-sm btn-danger" onclick="deleteMeasurementValue(' + m_value['id'] + ')">';
      tablerows += '<span class="glyphicon glyphicon-trash"></span></button></td>';
      tablerows += '</tr>';
    });

    // if we have to recreate the table, we first drop the existing rows
    if (extendList !== undefined && extendList === false) {
      $('.mValRow').remove();
    }

    $('#measurementval_table  tr:last').after(tablerows);

    if(data.length < newLimit) {
      $('#loadMoreButton').hide();
    } else {
      $('#loadMoreButton').show();
    }

    offset += newLimit;
    addChartData(data);
  });
}

function saveMeasurementValue() {
  var measurementId = $('#measurement_id').val();
  var timestamp = $('#timestamp').val();
  var val_a = $('#value_a').val();
  var val_b = $('#value_b').val();
  var val_c = $('#value_c').val();

  // Validate values
  if(!isFormValid())
    return;

  var measurementVal = [{
    MeresId : measurementId,
    Timestamp : timestamp,
    ErtekA : val_a,
    ErtekB : val_b,
    ErtekC : val_c
  }];

  $.ajax({
    type : 'POST',
    url : baseUrl + 'measurementvalue/save_json/',
    data : JSON.stringify(measurementVal),
    contentType : 'application/json; charset=utf-8',
  }).done(function(data) {

    loadMeasurementValues(false);

    $('#timestamp').val("");
    $('#value_a').val("");
    $('#value_b').val("");
    $('#value_c').val("");
  });
}

function deleteMeasurementValue(element_id) {
  var measurementValIdArray = [element_id];
  $.ajax({
    type : 'POST',
    url : baseUrl + 'measurementvalue/delete_permanent/',
    data : JSON.stringify(measurementValIdArray),
    contentType : 'application/json; charset=utf-8',
  }).done(function(data) {
    loadMeasurementValues(false);
  });
}

function isFormValid() {
  var wasValid = true;

  if(!isDateTime($('#timestamp').val())) {
    $('#timestamp').closest('.form-group').addClass('has-error');
    wasValid = false;
  }

  if(!isNumber($('#value_a').val())) {
    $('#value_a').closest('.form-group').addClass('has-error');
    wasValid = false;
  }

  if(!isNumber($('#value_b').val())) {
    $('#value_b').closest('.form-group').addClass('has-error');
    wasValid = false;
  }

  if(!isNumber($('#value_c').val())) {
    $('#value_c').closest('.form-group').addClass('has-error');
    wasValid = false;
  }

  return wasValid;
}

function isNumber(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}

function isDateTime(d) {
  var date_regex = /^(?:20|19)[0-9]{2}([-.\\])(?:0?[1-9]|1[012])\1(?:0?[1-9]|[12][0-9]|3[01]) ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(|.[0-9]*)$/;
  return date_regex.test(d);
}
