/*
 * Bootstrap Image Gallery JS Demo 3.0.1
 * https://github.com/blueimp/Bootstrap-Image-Gallery
 *
 * Copyright 2013, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */

/*jslint unparam: true */
/*global blueimp, $ */

var baseUrl = 'http://localhost/Web/';

function loadMeasurementImages() {

  var measurementId = $('#measurement_id').val();

  $.ajax({
    url : baseUrl + 'measurementimage/image/' + measurementId,
    cache : false
  }).done(function (result) {
      console.log("Images JSON: "+ result);
        var linksContainer = $('#links');
        // Add the demo images as links with thumbnails to the page:
        var imgPath, imgName, imgBaseUrl="";
        
       result.forEach(function(m_image) {
         
         imgPath = m_image['LokalisElerhetoseg'];
         imgName = imgPath.substring(imgPath.indexOf("uploads/"));         
         imgBaseUrl = baseUrl + imgName;
         
         console.log("Image path: "+ imgBaseUrl);
          
          $('<a/>')
              .append($('<img>').prop('src', imgBaseUrl ).prop('style', "height:100px;"))  
              .prop('href', imgBaseUrl)              
              .prop('title', 'mérés kép')
              .attr('data-gallery', '')
              .appendTo(linksContainer);
        });
    });    
}


function saveMeasurementImage(){  
  
  var measurementId = $('#measurement_id').val();
  var images =  document.getElementById('image');
  // Create a formdata object and add the files
  var data = new FormData();
   /* Add the file */ 
  data.append("image", images.files[0]);
  // console.log("Images JSON: "+ data);  

  $.ajax({
    type : "POST",
    url : baseUrl + 'measurementimage/image/' + measurementId,
    data : data, 
    cache: false,
    dataType: 'json',
    processData: false, // Don't process the files
    contentType: false // 'multipart/form-data'
  }).done(function(data) {
    // doesn't work -> use fail branch as well
    console.log("loadImages called"); 
    loadMeasurementImages();
    images.empty();
  });
}


