function loadMeasurementImages() {
  var measurementId = $('#measurement_id').val();

  $.ajax({
    url : baseUrl + 'measurementimage/image/' + measurementId,
    cache : false
  }).done(function (result) {
        var linksContainer = $('#links');
        linksContainer.empty();
        // Add the demo images as links with thumbnails to the page:
        var imgFullPath, imgSubPath, imgBaseUrl, imgName = "";

       result.forEach(function(m_image) {

         imgFullPath = m_image['LokalisElerhetoseg'];
         imgSubPath = imgFullPath.substring(imgFullPath.indexOf("uploads/"));
         imgBaseUrl = baseUrl + imgSubPath;
         imgName = imgSubPath.split('/').pop();

          $('<div>')
            .prop('id', 'floating_gallery_div')
            .append($('<a/>')
              .append($('<img>')
                  .prop('src', imgBaseUrl)
                  .height(100))
              .prop('href', imgBaseUrl)
              .prop('title', imgName)
              .attr('data-gallery', '')
            )
            .append($('<button>')
                  .prop('type','submit')
                  .prop('class','btn btn-sm btn-danger btn-overline')
                  .attr('onclick','deleteMeasurementImage(' + m_image['id'] + ')')
                    .append($('<span>')
                      .prop('class', 'glyphicon glyphicon-trash')
                      .prop('aria-hidden', 'true')
                    )
           )
          .appendTo(linksContainer);
        });
    });
}

function saveMeasurementImage(){

  var measurementId = $('#measurement_id').val();
  var images =  document.getElementById('image');
  // Create a formdata object and add the files
  var data = new FormData();
   /* Add the file */
  data.append("image", images.files[0]);

  $.ajax({
    type : "POST",
    url : baseUrl + 'measurementimage/image/' + measurementId,
    data : data,
    cache: false,
    dataType: 'json',
    processData: false, // Don't process the files
    contentType: false // 'multipart/form-data'
  }).done(function(data) {
    loadMeasurementImages();
  }) .fail( function(xhr, textStatus, errorThrown) {
        alert(xhr.responseText);
  });
}

function deleteMeasurementImage(element_id){
    var measurementImgIdArray = [element_id];

  $.ajax({
    type : "POST",
    url : baseUrl + 'measurementimage/delete_permanent/',
    data : JSON.stringify(measurementImgIdArray),
    contentType : "application/json; charset=utf-8",
  }).done(function(data) {

    loadMeasurementImages();
  });
}
