var chart;
var dataX = [];
var dataY = [];
var dataZ = [];

jQuery(document).ready(function($) {
  var chartDiv = document.getElementById('chartContainer');
  if (chartDiv == null) return;

  chart = new CanvasJS.Chart("chartContainer", {
    title:{
      text: "Mért értékek"
    },
    data: [
      {
        type: "line",
        dataPoints: dataX
      },
      {
        type: "line",
        dataPoints: dataY
      },
      {
        type: "line",
        dataPoints: dataZ
      }
    ]
  });

  chart.render();
});

function addChartData(data) {
  var timeStamp;
  data.forEach(function(value) {
    timestamp = new Date(value['Timestamp']);
    dataX.push({x: timeStamp, y: parseFloat(value['ErtekA'])});
    dataY.push({x: timeStamp, y: parseFloat(value['ErtekB'])});
    dataZ.push({x: timeStamp, y: parseFloat(value['ErtekC'])});
  });
  chart.render();
}

function clearChartData() {
  dataX.length = 0;
  dataY.length = 0;
  dataZ.length = 0;
}
