jQuery(document).ready(function($) {
  $('#device').change(function() {
    var deviceId = $('#device').val() ? $('#device').val() : -1;
    var sensorId = $('#sensor').val();

    $.ajax({
      url : baseUrl + 'sensor/get_by_device/' + deviceId,
    }).done(function(sensors) {
      var options = '<option value=""></option>';

      sensors.forEach(function(sensor) {
        options += '<option value="' + sensor['id'] + '">' + sensor['Nev'] + '</option>';
      });

      $('#sensor').html(options);
      $('#sensor').val(sensorId);
      $('#sensor').trigger("chosen:updated");
    });
  });

  $('#sensor').change(function() {
    var sensorId = $('#sensor').val() ? $('#sensor').val() : -1;
    var deviceId = $('#device').val();

    $.ajax({
      url : baseUrl + 'device/get_by_sensor/' + sensorId,
    }).done(function(devices) {
      var options = '<option value=""></option>';

      devices.forEach(function(device) {
        options += '<option value="' + device['id'] + '">' + device['Leiras'] + '</option>';
      });

      $('#device').html(options);
      $('#device').val(deviceId);
      $('#device').trigger("chosen:updated");
    });
  });

  $('#timestamp, #value_a, #value_b, #value_c').change(function() {
    $(this).closest('.form-group').removeClass('has-error');
  });

  var measurementId = $('#measurement_id').val();
  if(measurementId > 0){
    loadMeasurementValues(false);
    loadMeasurementImages();
  }
});
