<?php
  $user_ids = array();
  foreach($users_for_measurement as $value)
  {
    array_push($user_ids, $value->id);
  }
  $this->load->library('form_validation');
  $measurement = !empty($measurements) ? $measurements[0] : NULL;
  echo '<h1>'. $title .'</h1>';
?>
<div class="control-label col-sm-5">
  <div class="row">
    <?php echo form_open('measurement/save', array('class'=>'form-horizontal', 'role'=>'form')) ?>
      <!-- ID -->
      <input type="hidden" id="id" name="id" value="<?php echo set_value('id', !is_null($measurement) ? $measurement -> id : 0); ?>" >

      <!-- Date -->
      <div class="form-group <?php echo(form_error('date')) ? 'has-error has-feedback' : ''; ?>">
        <label class="control-label col-sm-2" for="date">Dátum:</label>
        <div class="col-sm-10">
          <input type="text" class="form-control datepicker" id="date" name="date" value="<?php echo set_value('date', !is_null($measurement) ? $measurement -> Datum : ""); ?>" placeholder="ÉÉÉÉ-HH-NN">
          <?php echo(form_error('date')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
        </div>
        <?php echo form_error('date'); ?>
      </div>

      <!-- Time -->
      <div class="form-group <?php echo(form_error('time')) ? 'has-error has-feedback' : ''; ?>">
        <label class="control-label col-sm-2" for="date">Idő:</label>
        <div class="col-sm-10">
          <input type="text" class="form-control" id="time" name="time" value="<?php echo set_value('time', !is_null($measurement) ? $measurement -> Ido : ""); ?>" placeholder="ÓÓ:PP:MM">
          <?php echo(form_error('time')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
        </div>
        <?php echo form_error('time'); ?>
      </div>

      <!-- Device -->
      <div class="form-group <?php echo(form_error('device')) ? 'has-error' : ''; ?>">
        <label class="control-label col-sm-2" for="device">Eszköz:</label>
        <div class="col-sm-10">
          <select data-placeholder="Válassz eszközt..." class="chosen-select" id="device" name="device">
            <?php
            echo '<option value=""></option>';
            foreach ($devices as $device) {
              echo '<option value="' . $device -> id . '" ' . set_select('device', $device -> id, (!is_null($measurement) && $measurement -> EszkozId == $device -> id)) . '>' . $device -> Leiras . '</option>';
            }
            ?>
          </select>
        </div>
        <?php echo form_error('device'); ?>
      </div>

      <!-- Sensor -->
      <div class="form-group <?php echo(form_error('sensor')) ? 'has-error' : ''; ?>">
        <label class="control-label col-sm-2" for="sensor">Alkatrész:</label>
        <div class="col-sm-10">
          <select data-placeholder="Válassz alkatrészt..." class="chosen-select" id="sensor" name="sensor">
            <?php
            echo '<option value=""></option>';
            foreach ($sensors as $sensor) {
              echo '<option value="' . $sensor -> id . '" ' . set_select('sensor', $sensor -> id, (!is_null($measurement) && $measurement -> AlkatreszId == $sensor -> id)) . '>' . $sensor -> Nev . '</option>';
            }
            ?>
          </select>
        </div>
        <?php echo form_error('sensor'); ?>
      </div>

      <!-- Description -->
      <div class="form-group <?php echo(form_error('description')) ? 'has-error has-feedback' : ''; ?>">
        <label class="control-label col-sm-2" for="date">Leírás:</label>
        <div class="col-sm-10">
          <textarea class="form-control" id="description" name="description" rows="3" placeholder="Leírás..."><?php echo set_value('description', !is_null($measurement) ? $measurement -> Leiras : ""); ?></textarea>
          <?php echo(form_error('description')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
        </div>
        <?php echo form_error('description'); ?>
      </div>

      <!-- Users -->
      <div class="form-group <?php echo (form_error('users')) ? 'has-error has-feedback' : ''; ?>">
        <label class="control-label col-sm-2" for="users">Felelősök:</label>
        <div class="col-sm-10">
          <select data-placeholder="Válassz felelősöket..." class="form-control chosen-select" multiple="multiple" id="users[]" name="users[]">
            <?php
            echo '<option value=""></option>';
            foreach($users as $user)
            {
              echo '<option value="'. $user->id .'" ' . set_select('users', $user->id, (in_array($user->id,$user_ids))) . '>'. $user->Nev.'</option>';
            }
            ?>
          </select>
        </div>
        <?php echo form_error('users'); ?>
      </div>

      <!-- Submit -->
      <div class="form-group">
        <div class="col-sm-offset-2 col-sm-10">
          <button type="submit" class="btn btn-lg btn-primary">Mentés</button>
        </div>
      </div>
    </form>
  </div>
</div>
<div class="control-label col-sm-7">
  <?php if(is_null($measurement)) : ?>
    <div class="alert alert-warning col-sm-offset-1" role="alert">
      <p>Kép és mért érték feltöltése a mérés mentése után lehetséges</p>
    </div>
  <?php else : ?>
    <!-- ____________Form for uploading images______________________________________ -->
    <div class="row">
      <label class="control-label col-sm-5 col-sm-offset-1" for="image">Méréskép feltöltése:</label>
    </div>
    <div class="row">
      <!-- File upload -->
      <div class="col-sm-offset-1 col-sm-7">
        <input type="file"  id="image" name="image" class="form-control" accept="image/*" style="padding-bottom: 35px;">
      </div>

      <!-- Submit -->
      <div class="col-sm-2">
        <button type="submit" class="btn btn-lg btn-primary" onclick="saveMeasurementImage()">Mentés</button>
      </div>
    </div>
    <div class="row">
      <div class="control-label col-sm-11 col-sm-offset-1" id="links" style="margin-top: 20px;"></div>
      <!-- The Bootstrap Image Gallery lightbox, is a child element of the document body (is at the end of this html)-->
    </div>

    <div class="row col-sm-offset-0 col-sm-12">
      <div id="chartContainer"></div>
    </div>

    <!-- ____________Form for inputing measurement values______________________________________ -->
    <div class="row">
      <label class="control-label col-sm-5 col-sm-offset-1" for="sheet" style="margin-top: 30px;" >Mért értékek feltöltése:</label>
    </div>
    <div class="row">
      <!-- table of measurement values -->
      <div class="form-group <?php echo (form_error('measurement_values')) ? 'has-error' : ''; ?>">
        <div class="col-sm-10 col-sm-offset-1">
          <!-- ID -->
          <input type="hidden" id="measurement_id" name="measurement_id" value="<?php echo set_value('measurement_id', !is_null($measurement) ? $measurement -> id : 0); ?>" >

          <table id="measurementval_table" class="table table-striped">
            <thead>
              <tr>
                <td>Idő</td>
                <td>Érték A</td>
                <td>Érték B</td>
                <td>Érték C</td>
                <td></td>
              </tr>
            </thead>
            <tbody>
              <tr id="input_row">
                <!-- Time -->
                <td>
                  <div class="form-group <?php echo(form_error('timestamp')) ? 'has-error has-feedback' : ''; ?>">
                    <div>
                      <input type="text" class="form-control" id="timestamp" name="timestamp" placeholder="Idő...">
                      <?php echo(form_error('timestamp')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
                    </div>
                    <?php echo form_error('timestamp'); ?>
                  </div>
                </td>
                <!-- Value A -->
                <td>
                  <div class="form-group form-no-margin <?php echo(form_error('value_a')) ? 'has-error has-feedback' : ''; ?>" >
                    <div>
                      <input type="text" class="form-control" id="value_a" name="value_a" placeholder="Érték...">
                      <?php echo(form_error('value_a')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
                    </div>
                    <?php echo form_error('value_a'); ?>
                  </div>
                </td>
                <!-- Value B -->
                <td>
                  <div class="form-group form-no-margin <?php echo(form_error('value_b')) ? 'has-error has-feedback' : ''; ?>" >
                    <div>
                      <input type="text" class="form-control" id="value_b" name="value_b" placeholder="Érték...">
                      <?php echo(form_error('value_b')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
                    </div>
                    <?php echo form_error('value_b'); ?>
                  </div>
                </td>
                <!-- Value C -->
                <td>
                  <div class="form-group form-no-margin <?php echo(form_error('value_c')) ? 'has-error has-feedback' : ''; ?>" >
                    <div>
                      <input type="text" class="form-control" id="value_c" name="value_c" placeholder="Érték...">
                      <?php echo(form_error('value_c')) ? '<span class="glyphicon glyphicon-remove form-control-feedback"></span>' : ''; ?>
                    </div>
                    <?php echo form_error('value_c'); ?>
                  </div>
                </td>
                <!-- Add element -->
                <td>
                  <button type="submit" class="btn btn-lg btn-primary" onclick="saveMeasurementValue()">+</button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <div class="row" >
      <button id="loadMoreButton" type="submit" onclick="loadMeasurementValues()" class="btn btn-lg btn-default col-sm-offset-2 col-sm-7">Mutass többet</button>
    </div>
  <?php endif; ?>
</div>

<!-- ____________THE IMAGE SLIDER______________________________________ -->
<div id="blueimp-gallery" class="blueimp-gallery">
  <!-- The container for the modal slides -->
  <div class="slides"></div>
  <!-- Controls for the borderless lightbox -->
  <h3 class="title"></h3>
  <a class="prev">‹</a>
  <a class="next">›</a>
  <a class="close">×</a>
  <a class="play-pause"></a>
  <ol class="indicator"></ol>
  <!-- The modal dialog, which will be used to wrap the lightbox content -->
  <div class="modal fade">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" aria-hidden="true">&times;</button>
          <h4 class="modal-title"></h4>
        </div>
        <div class="modal-body next"></div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default pull-left prev">
            <i class="glyphicon glyphicon-chevron-left"></i>
            Previous
          </button>
          <button type="button" class="btn btn-primary next">
            Next
            <i class="glyphicon glyphicon-chevron-right"></i>
          </button>
        </div>
      </div>
    </div>
  </div>
</div>
