<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends MY_Model {

  public function __construct()
  {
    // Call the MY_Model constructor
    parent::__construct();
    $this->my_table_name = $this->user_table;
  }
  


  protected function _get($id = -1, $limit = -1, $offset = -1)
  {
    $curr_table = $this->my_table_name;
    $this->db->from($curr_table);
    $this->db->order_by('Nev');

    if($id > -1)
    {
      $this->db->where('id', $id);
    }

    if($limit > -1 && $offset > -1)
    {
      $this->db->limit($limit, $offset);
    }

    $query = $this->db->get();
    return $query->result();
  }
  
  /*
   * -------------- Measurementuser methods ----------------
   */
  
    public function get_by_measurement_id($measurementid){
    
    $curr_table = $this->my_table_name;
    $this->db->from($curr_table);
    $this->db->join($this->measurement_user_table, $this->measurement_user_table .'.MeresId =' . $measurementid 
    .' and ' . $this->measurement_user_table 
    .'.UserId = ' . $curr_table . '.id' );
    $this->db->order_by($curr_table . '.Nev');
    
    $query = $this->db->get();
    return $query->result();
  }
  
  public function get_measurementuser($measuremetn_id, $user_id){
    
    $this->db->from('meresuser');

    $this->db->where('MeresId', $measuremetn_id);
    $this->db->where('UserId', $user_id);

    $query = $this->db->get();
    return $query->result();    
  }

  public function get_measurementuser_by_measurementid($measuremetn_id){
      
      $this->db->from('meresuser');
  
      $this->db->where('MeresId', $measuremetn_id);
  
      $query = $this->db->get();
      return $query->result();    
    }
  
  
  public function delete_measurementusers($ids)
    {
      $this->db->where_in('ssz', $ids);
      return $this->db->delete('meresuser');
    }
  
    public function save_measurementuser($data)
    {
      return $this->db->insert('meresuser', $data);
    }
}
