<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sensor_model extends MY_Model {

  public function __construct()
  {
    // Call the MY_Model constructor
    parent::__construct();
    $this->my_table_name = $this->sensor_table;
  }

  protected function _build_query()
  {
    $curr_table = $this->my_table_name;
    $this->db->select($curr_table .'.*, '. $this->sensorcat_table .'.Kategoria');
    $this->db->from($curr_table);
    $this->db->join($this->sensorcat_table, $this->sensorcat_table .'.id = '. $curr_table .'.AlkatreszKatId');
    $this->db->order_by($curr_table .'.Nev');
  }

  public function get_by_device_id($device_id)
  {
    $this->_build_query();
    $this->db->select($this->my_table_name .'.*');
    $this->db->where($this->my_table_name .'.'. $this->flag_column, 0); // Exclude deleted records
    if($device_id > 0)
    {
      $this->db->join($this->device_sensor_table, $this->my_table_name .'.id = '. $this->device_sensor_table .'.AlkatreszId AND '. $this->device_sensor_table .'.EszkozId = '. $device_id);
    }
    
    $query = $this->db->get();
    return $query->result();
  }
}
