<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Measurement_model extends MY_Model {

  public function __construct() {
    // Call the CI_Model constructor
    parent::__construct();
    $this -> my_table_name = $this -> measurement_table;
  }

  protected function _build_query() {
    // Modify it to allow multiple users for one measurement
    $curr_table = $this -> my_table_name;
    $this -> db -> select($curr_table . '.*, '
    . $this -> device_table . '.id AS EszkozId, '
    . $this -> device_table . '.Leiras AS EszkozLeiras, '
    . $this -> sensor_table . '.id AS AlkatreszId, '
    . $this -> sensor_table . '.Nev AS AlkatreszNev, '
    . 'GROUP_CONCAT('. $this -> user_table . '.Nev SEPARATOR ", ") AS Usernames');
    $this -> db -> from($curr_table);
    $this -> db -> join($this -> device_sensor_table, $this -> device_sensor_table . '.ssz = ' . $curr_table . '.EszkozalkatreszId');
    $this -> db -> join($this -> device_table, $this -> device_table . '.id = ' . $this -> device_sensor_table . '.EszkozId');
    $this -> db -> join($this -> sensor_table, $this -> sensor_table . '.id = ' . $this -> device_sensor_table . '.AlkatreszId');
    $this -> db -> join($this -> measurement_user_table, $this -> measurement_user_table . '.MeresId = ' . $curr_table . '.id', 'left');
    $this -> db -> join($this -> user_table, $this -> user_table . '.id = ' . $this -> measurement_user_table . '.UserId', 'left');
    $this -> db -> group_by($curr_table . '.id');
    $this -> db -> order_by($this -> sensor_table . '.Nev');
  }

  public function filter($uid = -1, $devid = -1)
  {
    // Create base query
    $this->_build_query();

    // Filter by userid and deviceid
    if($uid>-1)
    $this->db->where($this->user_table . '.id',$uid);

    if($devid>-1)
    $this->db->where($this->device_table . '.id',$devid);

    $query = $this->db->get();
    return $query->result();
  }

  public function search($string, $option = -1)
  {
    // Create base query
    $this->_build_query();

    // Search by username and/or devicename
    if($option==2) // both
    {
      $this->db->like($this->device_table . '.Leiras', $string);
      $this->db->or_like($this->user_table . '.Nev', $string);
    }

    else if($option==0) // only username
    {
      $this->db->like($this->user_table . '.Nev', $string);
    }

		else if($option==1) // only devicename
    {
      $this->db->like($this->device_table . '.Leiras', $string);
    }

    $query = $this->db->get();
    return $query->result();
  }

  public function get_by_device_and_sensor($deviceId, $sensorId)
  {
    $curr_table = $this->my_table_name;
    $this->db->select($curr_table .'.*, '
      . $this->sensor_table.'.Nev AS SzenzorNev, ');
    $this->db->from($curr_table);
    $this->db->join($this->device_sensor_table, $this->device_sensor_table .'.ssz = '. $curr_table .'.EszkozalkatreszId'
      .' AND '. $this->device_sensor_table .'.EszkozId = '. $deviceId
      .' AND '. $this->device_sensor_table .'.AlkatreszId = '. $sensorId);
    $this->db->join($this->sensor_table, $this->sensor_table . '.id = ' . $this->device_sensor_table . '.AlkatreszId');

    $query = $this->db->get();
    return $query->result();
  }
}
