<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Device_sensor_model extends CI_Model {

  public function __construct()
  {
    // Call the CI_Model constructor
    parent::__construct();
  }

  public function get_all()
  {
    return $this->_get();
  }

  public function get($limit = 20, $offset = 0)
  {
    return $this->_get(-1, -1, $limit, $offset);
  }

  public function get_by_device_id($device_id)
  {
    return $this->_get($device_id);
  }

  public function get_by_sensor_id($sensor_id)
  {
    return $this->_get(-1, $sensor_id);
  }

  public function get_by_ids($device_id, $sensor_id)
  {
    return $this->_get($device_id, $sensor_id);
  }

  private function _get($device_id = -1, $sensor_id = -1, $limit = -1, $offset = -1)
  {
    $this->db->from('eszkozalkatresz');

    if($device_id > -1)
    {
      $this->db->where('EszkozId', $device_id);
    }

    if($sensor_id > -1)
    {
      $this->db->where('AlkatreszId', $sensor_id);
    }

    if($limit > -1 && $offset > -1)
    {
      $this->db->limit($limit, $offset);
    }

    $query = $this->db->get();
    return $query->result();
  }

  public function count()
  {
    return $this->db->count_all('eszkozalkatresz');
  }

  public function save($data)
  {
    return $this->db->insert('eszkozalkatresz', $data);
  }

  public function delete_by_device($ids)
  {
    $this->db->where_in('EszkozId', $ids);
    return $this->db->delete('eszkozalkatresz');
  }

  public function delete($ids)
  {
    $this->db->where_in('ssz', $ids);
    return $this->db->delete('eszkozalkatresz');
  }

  public function delete_by_sensor($ids)
  {
    $this->db->where_in('AlkatreszId', $ids);
    return $this->db->delete('eszkozalkatresz');
  }
}
