<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Device_model extends MY_Model {

  public function __construct()
  {
    // Call the CI_Model constructor
    parent::__construct();
    $this->my_table_name = $this->device_table;
  }

  protected function _build_query()
  {
    $this->db->from($this->my_table_name);
    $this->db->order_by('Leiras');
  }

  public function get_by_sensor_id($sensor_id)
  {
    $this->_build_query();
    $this->db->select($this->my_table_name .'.*');
    $this->db->where($this->my_table_name .'.'. $this->flag_column, 0); // Exclude deleted records
    if($sensor_id > 0)
    {
      $this->db->join($this->device_sensor_table, $this->my_table_name .'.id = '. $this->device_sensor_table .'.EszkozId AND '. $this->device_sensor_table .'.AlkatreszId = '. $sensor_id);
    }

    $query = $this->db->get();
    return $query->result();
  }
}
