<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class MY_Form_validation extends CI_Form_validation {
    /**
     * MY_Form_validation::is_date().
     * Date type.
     */
    function is_date($date) {
        $this->CI->form_validation->set_message('is_date', 'Csak a következő dátumformátumban adható meg: ÉÉÉÉ-HH-NN vagy ÉÉÉÉ.HH.NN.');
        // Simple regex: /^[0-9]{4}-[0-9]{2}-[0-9]{2}$/y
        if (preg_match( "/^(?:20|19)[0-9]{2}([-.\\/])(?:0?[1-9]|1[012])\\1(?:0?[1-9]|[12][0-9]|3[01])$/", $date)) {
            return TRUE;
        }
        else {
            return FALSE;
        }
    }
    // add more function to apply custom rules.

    function is_time($time) {
        $this->CI->form_validation->set_message('is_time', 'Csak a következő formátumban adható meg: ÓÓ:PP:MP');
        if (preg_match( "/^([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$/", $time)) {
            return TRUE;
        }
        else {
            return FALSE;
        }
    }
}
