<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Model extends CI_Model {

  public $my_table_name = '';

  public $user_table = 'user';
  public $sensor_table = 'alkatresz';
  public $sensorcat_table = 'alkatreszkat';
  public $device_sensor_table = 'eszkozalkatresz';
  public $device_table = 'eszkoz';
  public $distributor_table = 'forgalmazo';
  public $availability_table = 'beszerezhetoseg';
  public $measurement_table = 'meres';
  public $measurement_image_table = 'mereskep';
  public $measurement_value_table ='mertertek';
  public $measurement_user_table = 'meresuser';

  public $flag_column = "Flag";

  public function get($limit = 20, $offset = 0)
  {
    return $this->_get(-1, $limit, $offset);
  }

  public function get_all()
  {
    return $this->_get();
  }

  public function get_by_id($id)
  {
    return $this->_get($id);
  }

  protected function _build_query()
  {
    // To be implemented !!!!
  }

  protected function _get($id = -1, $limit = -1, $offset = -1)
  {
    $this->_build_query();
    // Exclude deleted records
    $this->db->where($this->my_table_name .'.'. $this->flag_column, 0);

    if($id > -1)
    {
      $this->db->where($this->my_table_name .'.id', $id);
    }

    if($limit > -1 && $offset > -1)
    {
      $this->db->limit($limit, $offset);
    }

    $query = $this->db->get();
    return $query->result();
  }

  /*-----------------------------------------
  *-       General code
  *-----------------------------------------
  */
  public function count()
  {
    $this->db->where($this->my_table_name .'.'. $this->flag_column, 0);
    return $this->db->count_all_results($this->my_table_name);
  }

  public function save($my_item)
  {
    if(!isset($my_item['id']) || $my_item['id'] < 1)
    {
      unset($my_item['id']);
      $this->db->insert($this->my_table_name, $my_item);
      return $this->db->insert_id(); //returns last inserted item's id
    }
    else
    {
      $this->db->where('id', $my_item['id']);
      $this->db->update($this->my_table_name, $my_item);
      return $my_item['id'];
    }
  }

  public function insert_batch($array)
  {
    $this->db->insert_batch($this->my_table_name, $array);
  }

  public function delete($ids)
  {
    $data = array($this->flag_column => 1);
    $this->db->where_in('id', $ids);
    return $this->db->update($this->my_table_name, $data);
  }
  
  public function delete_permanent($ids)
  {
    $this->db->trans_start();
    $this->db->where_in('id', $ids);
    $message = $this->db->delete($this->my_table_name); 
    $this->db->trans_complete();
    
    return $message;    
  }
}
