<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller {
  public $model_name = '';
  public $model = NULL;
  public $name = '';
  public $title = '';
  public $title_create = '';
  public $title_modify = '';
  public $load_chosen = FALSE;

  private $css = array();
  private $js = array();

  public function __construct($config)
  {
    parent::__construct();
    $this->model_name = $config['model_name'];
    $this->name = $config['name'];
    $this->title = isset($config['title']) ? $config['title'] : $this->title;
    $this->title_create = isset($config['title_create']) ? $config['title_create'] : $this->title_create;
    $this->title_modify = isset($config['title_modify']) ? $config['title_modify'] : $this->title_modify;
    $this->load_chosen = isset($config['load_chosen']) ? $config['load_chosen'] : $this->load_chosen;
    $this->model = $this->get_current_model();
  }

  // Model names
  public $availability_model_name = 'availability_model';
  public $device_model_name = 'device_model';
  public $device_sensor_model_name = 'device_sensor_model';
  public $distributor_model_name = 'distributor_model';
  public $measurement_model_name = 'measurement_model';
  public $measurement_user_model_name = 'meresuser';
  public $measurement_value_model_name ='measurement_value_model';
  public $measurement_image_model_name ='measurementimage_model';
  public $sensor_cat_model_name = 'sensor_cat_model';
  public $sensor_model_name = 'sensor_model';
  public $user_model_name = 'user_model';

  // View names
  public $availability_name = 'availability';
  public $device_name = 'device';
  public $distributor_name = 'distributor';
  public $sensor_name = 'sensor';
  public $user_name = 'user';
	public $measurement_name = 'measurement';
  public $measurement_value_name ='measurementvalue';
  public $measurement_image_name ='measurementimage';
  //-----------------------------------------------------

  /* Common HTML pages and their hooks */
  public function index($offset = 0, $limit = 0)
  {
    $index_view = $this->name . '/index';
    $curr_model = $this->get_current_model();

    // Initialize pagination
    $this->load->library('pagination');
    $config['base_url'] = site_url($index_view);
    $config['total_rows'] = $curr_model->count();
    $this->pagination->initialize($config);

    // Render data
    $limit = $limit ? $limit : $this->pagination->per_page;
    $data['records'] = $curr_model->get($limit, $offset);
    $data['total_rows'] = $config['total_rows'];

    if(!$this->input->is_json_request())
    {
      $template['title'] = $this->title;
      $template['main_content'] = $index_view;
      $template['data'] = $data;
      $this->showView($template);
    }
    else
    {
      $this->send_json($data['records']);
    }
  }

	// Both JSON and
  public function delete()
  {
		$curr_model = $this->get_current_model();

		if(!$this->input->is_json_request())
		{
			// Delete selected records
			$ids = $this->input->post('id[]');
			if(isset($ids))
			{
				$curr_model->delete($ids);
			}
			$this->reload_pagination();
		}
		else
		{
			$jsonArray = json_decode(file_get_contents('php://input'),true);
			if(isset($jsonArray))
			{
				$curr_model->delete($jsonArray);
			}
			$response = $this->build_error(0,$jsonArray);
			$this->send_json($response);
		}
  }

  // TODO: make it generic!!
  public function delete_permanent()
  {
    $curr_model = $this->get_current_model();

    if(!$this->input->is_json_request())
    {
      // Delete selected records
      $ids = $this->input->post('id[]');
      if(isset($ids))
      {
        $curr_model->delete_permanent($ids);
      }
    }
    else
    {
      $jsonArray = $this->get_posted_json();
      if(isset($jsonArray))
      {
        $curr_model->delete_permanent($jsonArray);
      }
      $response = $this->build_error(0, $jsonArray);
      $this->send_json($response);
    }
  }

  protected function reload_pagination()
  {
    $curr_model = $this->get_current_model();
    // Determine redirect url
    $this->load->library('pagination');
    $count = $curr_model->count();
    $limit = $this->pagination->per_page;
    $offset = $this->input->post('offset');
    $offset = ($offset < $count) ? $offset : max($offset - $limit, 0);

    $url = ($offset) ? '/'.$this->name . '/index/'.$offset : '/'.$this->name.'/';
    redirect($url);
  }

  private function load_chosen()
  {
    // Add extra files to the arrays
    array_push($this->css, 'css/chosen.min.css');
    array_push($this->js, 'js/chosen.jquery.min.js');
  }

  // Edit page data hook method
  protected function load_edit_data()
  {
    return array();
  }

  protected function load_edit_view($id, $data = array())
  {
    if($this->load_chosen)
    {
      $this->load_chosen();
    }
    // Load array from hook
    $edit_data = $this->load_edit_data();
    $data = array_merge($edit_data, $data);

    $template['title'] = $id ? $this->title_modify : $this->title_create;
    $template['main_content'] = $this->name . '/edit';
    $template['data'] = $data;
    $this->showView($template);
  }

  /* HTML related stuff */
  protected function load_css($css)
  {
    $this->css[$css] = $css;
  }

  protected function load_js($js)
  {
    $this->js[$js] = $js;
  }

  private function showView($template)
  {
    $template['css_files'] = $this->css;
    $template['js_files'] = $this->js;
    $this->load->view('template/template', $template);
  }

  /* JSON related stuff */
  protected function build_error($error_code, $error_msg)
  {
    return array('errorCode' => $error_code, 'errorMsg' => $error_msg);
  }

  protected function get_posted_json()
  {
    return json_decode(file_get_contents('php://input'), TRUE);
  }

  protected function send_json($data)
  {
    $this->output
  		->set_content_type('application/json')
  		->set_output(json_encode($data));
  }

  /* Model related stuff */
  private function get_current_model()
  {
    $this->load->model($this->model_name);
    $curr_m_string = $this->model_name;
    $curr_model=$this->{$curr_m_string};
    return $curr_model;
  }
}
