<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends MY_Controller {


	public function __construct()
	{
		$config = array(
			'model_name' => $this->user_model_name,
			'name' => $this->user_name,
			'title' => 'Felhasználók',
			'title_create' => 'Új felhasználó',
			'title_modify' => 'Felhasználó módosítása'
		);

		parent::__construct($config);
	}

	public function edit($id)
	{
		// Render data
		$data['user'] = $this->user_model->get_by_id($id);
		$this->load_edit_view($id, $data);
	}

	public function save()
	{
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Teljes név', 'required');
		$this->form_validation->set_rules('status', 'Státusz', 'required');
		$has_error = ($this->form_validation->run() === FALSE);

		if($has_error)
		{
			$id = $this->input->post('id');
			$this->load_edit_view($id);
			return;
		}

		$user = array(
			'id' => $this->input->post('id'),
			'Nev' => $this->input->post('name'),
			'Statusz' => $this->input->post('status')
		);

		$this->user_model->save($user);
		redirect('/'. $this->name);

	}
}
