<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sensor extends MY_Controller {

	public function __construct()
	{
		$config = array(
			'model_name' => $this->sensor_model_name,
			'name' => $this->sensor_name,
			'title' => 'Alkatrészek',
			'title_create' => 'Új alkatrész',
			'title_modify' => 'Alkatrész módosítása',
			'load_chosen' => TRUE
		);

		parent::__construct($config);
	}

	public function get_by_device($device_id = NULL)
	{
		$data = ($device_id) ?
			$this->sensor_model->get_by_device_id($device_id) :
			$this->build_error(1, 'deviceId megadása kötelező');

		$this->send_json($data);
	}

	protected function load_edit_data()
	{
		// Load data for <select>-s
		$this->load->model('sensor_cat_model');
		$data['sensor_categories'] = $this->sensor_cat_model->get_all();
		return $data;
	}

	public function edit($id)
	{
		// Render data
		$data['sensor'] = $this->sensor_model->get_by_id($id);
		$this->load_edit_view($id, $data);
	}

	public function save()
	{
		// Validate data
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'Név', 'required');
		$this->form_validation->set_rules('category', 'Kategória', 'required');
		$this->form_validation->set_rules('web', 'Weboldal', 'valid_url');
		$this->form_validation->set_rules('voltage', 'Üzemi feszültség', 'required|is_numeric');
		$this->form_validation->set_rules('consumption', 'Teljesítmény felvétel', 'required|is_numeric');

		$file_error = NULL;
		$has_error = ($this->form_validation->run() === FALSE);

		// Upload sheet
		$file_path = NULL;
		if(!$has_error && $_FILES['sheet']['name'])
		{
			$config['upload_path'] = './uploads/sheets/';
			$config['allowed_types'] = 'pdf';
			$config['overwrite'] = TRUE;
			$this->load->library('upload', $config);

			if($has_error = !$this->upload->do_upload('sheet'))
			{
				$this->config->load('form_validation', TRUE);
				$prefix = $this->config->item('error_prefix', 'form_validation');
				$suffix = $this->config->item('error_suffix', 'form_validation');
				$file_error = $this->upload->display_errors($prefix, $suffix);
			}
			else
			{
				$file_path = $this->upload->data()['full_path'];
				log_message('debug', 'file success: ' . print_r($this->upload->data(), true));
			}
		}

		// Display error
		if($has_error)
		{
			// Add error message
			$id = $this->input->post('id');
			$data['file_error'] = $file_error;
			$this->load_edit_view($id, $data);
			return;
		}

		// Save and redirect
		$sensor = array(
			'id' => $this->input->post('id'),
			'Nev' => $this->input->post('name'),
			'AlkatreszKatId' => $this->input->post('category'),
			'Weboldal' => add_http($this->input->post('web')),
			'UzemiFeszultseg' => $this->input->post('voltage'),
			'TeljesitmenyFelvetel' => $this->input->post('consumption')
		);

		if($file_path)
		{
			$sensor['Adatlap'] = $file_path;
		}

		$this->sensor_model->save($sensor);
		redirect('/'. $this->name);
	}
}
