<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Measurementvalue extends MY_Controller {

	public function __construct()
	{
		$config = array(
			'model_name'=>$this->measurement_value_model_name,
			'name'=>$this->measurement_value_name,
			'load_chosen'=>FALSE
		);

		parent::__construct($config);
		$this -> load -> model($this -> measurement_model_name);
	}

	// ----------- JSON ------------------
	public function get_json($MeresId, $offset=0, $limit=-1)
	{
		$data = $this->measurement_value_model->get_by_measurement_id($MeresId, $limit, $offset);
		$this->send_json($data);
	}

	public function get_chart($MeresId, $limit=1000)
	{
		$data = $this->measurement_value_model->get_by_measurement_id($MeresId,-1, 0);
		$data_length = count($data);
		$avg_per = $data_length / $limit;
		$avg_per = $avg_per < 1 ? 1 : floor($avg_per);

		$chart_data = array();
		$avg_data = NULL;
		$n = 0;
		for($i = 0; $i < $data_length; $i++)
		{
			$n++;
			$act = $data[$i];

			if($avg_data == NULL)
			{
				$avg_data = $act;
			}
			else
			{
				$avg_data->ErtekA += $act->ErtekA;
				$avg_data->ErtekB += $act->ErtekB;
				$avg_data->ErtekC += $act->ErtekC;
			}

			if($n == $avg_per || $i + 1 == $data_length)
			{
				$avg_data->ErtekA /= $avg_per;
				$avg_data->ErtekB /= $avg_per;
				$avg_data->ErtekC /= $avg_per;

				array_push($chart_data, $avg_data);
				$avg_data = NULL;
				$n = 0;
			}
		}

		$this->send_json($chart_data);
	}

	public function save_json()
	{
		$jsonArray = $this->get_posted_json();

		foreach ($jsonArray as &$value)
		{
			if($value['Timestamp'] == "")
			{
				$value['Timestamp'] = $this->timeAndMilliseconds();
			}

			$value['TimestampMillis'] = $this->timeAndMillisecondsDec($value['Timestamp']);
		}

		$this->measurement_value_model->insert_batch($jsonArray);
		$response = $this->build_error(0, NULL);
		$this->send_json($response);
	}

	private function timeAndMilliseconds()
	{
		$m = explode(' ', microtime());
		return date("Y-m-d H:i:s", $m[1]) . '.' . (int) round($m[0] * 1000, 3);
	}

	private function timeAndMillisecondsDec($time)
	{
		$m = explode('.', $time);
		$date = '';
		if(isset($m[0]) && isset($m[1]))
		{
			$time = strtotime($m[0]);
			if($time !== FALSE)
			{
				$date = date("YmdHis", $time) . '.' . $m[1];
			}
		}
		return $date;
	}
}
