<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Measurementimage extends MY_Controller
{
	public function __construct()
	{
	  $config = array(
      'model_name'=>$this->measurement_image_model_name,
      'name'=>$this->measurement_image_name,
      'load_chosen'=>FALSE
    );

    parent::__construct($config);
	}

	// Upload or download
	public function image($meresId)
	{
		if($this->input->method() === 'post')
		{
			$this->send_image($meresId);
		}
		else
		{
			$this->get_image($meresId);
		}
	}

	private function get_image($meresId)
	{
		$image = $this->measurementimage_model->get_by_id($meresId);
		$this->send_json($image);
	}

	private function send_image($meresId)
	{
		// Setup picture upload
		$config['upload_path'] = './uploads/images/';
		$config['allowed_types'] = 'png|jpg|gif';
		$config['overwrite'] = TRUE;
		$this->load->library('upload', $config);

		// Upload and save
		if($this->upload->do_upload('image'))
		{
			$file_path = $this->upload->data()['full_path'];
			log_message('debug', 'file success: ' . print_r($this->upload->data(), true));

			$measuredimage['MeresId'] = $meresId;
			$measuredimage['LokalisElerhetoseg'] = $file_path;
			$this->measurementimage_model->save($measuredimage);

			// Create thumbnail
			$config = array();
			$config['image_library'] = 'gd2';
			$config['source_image'] = strstr($file_path, '/uploads');
			$config['create_thumb'] = TRUE;
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 150;
			$config['height'] = 150;
			$this->load->library('image_lib');
			$res = $this->image_lib->resize();

			log_message('debug', 'resize: ' . print_r($res, true));

			$response = $this->build_error(0, $file_path);
			$response['response'] = $file_path;
			$this->send_json($response);
		}
		else
		{
			$file_error = $this->upload->display_errors();
			$response = $this->build_error(1, $file_error);
			$this->send_json($response);
		}
	}
}
