<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Measurement extends MY_controller {

  private $controller_name = 'measurement';

  public function __construct() {
    $config = array(
    'model_name' => $this -> measurement_model_name,
    'name' => $this -> measurement_name,
    'title' => 'Mérések',
    'title_create' => 'Új mérés',
    'title_modify' => 'Mérés módosítása',
    'load_chosen' => TRUE);

    parent::__construct($config);
    $this -> load -> model($this -> measurement_model_name);
  }

  protected function load_edit_data() {
    $this->load_css('css/jquery-ui.min.css');
    $this->load_css('css/bootstrap-image-gallery.min.css');
    $this->load_css('css/blueimp-gallery.min.css');
    $this->load_css('css/bootstrap-image-gallery.min.css');

    $this->load_js('js/jquery-ui.min.js');
    $this->load_js('js/jquery.canvasjs.min.js');
    $this->load_js('js/jquery.blueimp-gallery.min.js');
    $this->load_js('js/bootstrap-image-gallery.min.js');
    $this->load_js('js/measurement.js');
    $this->load_js('js/measurement_value.js');
    $this->load_js('js/measurement_image.js');
    $this->load_js('js/measurement_chart.js');

    // Load data for <select>-s
    $this -> load -> model($this -> sensor_model_name);
    $data['sensors'] = $this -> sensor_model -> get_all();

    $this -> load -> model($this -> device_model_name);
    $data['devices'] = $this -> device_model -> get_all();

    $this -> load -> model($this -> user_model_name);
    $data['users'] = $this -> user_model -> get_all();

    return $data;
  }

  public function edit($id) {
    $this -> load -> model($this -> user_model_name);
    $data['users_for_measurement'] = $this -> user_model -> get_by_measurement_id($id);

    $data['measurements'] = $this -> measurement_model -> get_by_id($id);
    $this -> load_edit_view($id, $data);
  }

  public function save() {
    // Validate data
    $this -> load -> library('form_validation');
    $this -> form_validation -> set_rules('date', 'Dátum', 'required|is_date');
    $this -> form_validation -> set_rules('time', 'Idő', 'required|is_time');
    $this -> form_validation -> set_rules('device', 'Eszköz', 'required');
    $this -> form_validation -> set_rules('sensor', 'Alkatrész', 'required');
    //$this -> form_validation -> set_rules('users', 'Felelősök', 'required');

    $file_error = NULL;
    $has_error = ($this -> form_validation -> run() === FALSE);

    $this -> load -> model($this -> user_model_name);

    // Display error
    if ($has_error) {
      // Load data for <select>-s
      $id = $this -> input -> post('id');

      $data['users_for_measurement'] = $this -> user_model -> get_by_measurement_id($id);

      $this -> load_edit_view($id, $data);
      return;
    }

    // Get the corresponding device-sensor
    $device_id = $this -> input -> post('device');
    $sensor_id = $this -> input -> post('sensor');

    $this -> load -> model($this -> device_sensor_model_name);
    $curr_device_sensor = $this -> device_sensor_model -> get_by_ids($device_id, $sensor_id);

    //log_message('debug', 'Device sensor:' . print_r($curr_device_sensor, TRUE));

    // Save the measurement
    $measurement = array(
        'id' => $this -> input -> post('id'),
        'Datum' => $this -> input -> post('date'),
        'Ido' => $this -> input -> post('time'),
        'Leiras' => $this -> input -> post('description'),
        'EszkozalkatreszId' => $curr_device_sensor[0]->ssz
        );

    $measurementId = $this -> measurement_model -> save($measurement);

    // Link the users with the measurement
    $selected_users = array();
    $selected_users = $this->input->post('users[]');

    // get the list of original measurement users
    $old_m_users = $this -> user_model -> get_measurementuser_by_measurementid($measurementId);

    $ids_to_delete = array();
     foreach ($old_m_users as $old_m_user) {

      if(in_array($old_m_user->UserId, $selected_users)) //db:+ select:+
        {
          if(($key = array_search($old_m_user->UserId, $selected_users)) !== FALSE)
          {
            unset($selected_users[$key]);
          }
        }
        else //db:+ select:-
        {
            array_push($ids_to_delete, $old_m_user->ssz);
        }
    }

    // Delete existing relations which have been deleted by the user now
    if(!empty($ids_to_delete))
    {
      $this->measurement_model->delete_measurementusers($ids_to_delete);
    }

    // Create new relations which have been created by the user now
    foreach($selected_users as $user_id)
    {
      $data = array(
        'MeresId' => $measurementId,
        'UserId' => $user_id
      );
      $this->user_model->save_measurementuser($data);
    }

    redirect('/'. $this->name);
  }

	public function getmes_by_udid($uid = -1, $devid = -1)
	{
		$result = $this->measurement_model->filter($uid,$devid);

		$this->send_json($result);
	}

	public function search_by_name($string, $option = -1)
	{
		$string = urldecode($string);
		$result = $this->measurement_model->search($string, $option);

		$this->send_json($result);
	}
}
