<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Distributor extends MY_Controller
{
	public function __construct()
	{
		$config = array(
      'model_name' => $this->distributor_model_name,
      'name' => $this->distributor_name,
      'title' => 'Forgalmazók',
      'title_create' => 'Új forgalmazó',
      'title_modify' => 'Forgalmazó módosítása'
    );

    parent::__construct($config);
	}

	public function edit($id)
	{
		// Render data
		$data['distributor'] = $this->distributor_model->get_by_id($id);
		$this->load_edit_view($id, $data);
	}

	public function save()
	{
		// Validate data
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name','Név', 'required');
		$this->form_validation->set_rules('tel', 'Telefon', 'required');
		$this->form_validation->set_rules('web', 'Weboldal', 'required|valid_url');
		$has_error = ($this->form_validation->run() === FALSE);

		if($has_error)
		{
			$id = $this->input->post('id');
			$this->load_edit_view($id);
			return;
		}

		// Save and redirect
		$distributor = array(
			'id' => $this->input->post('id'),
			'Nev' => $this->input->post('name'),
			'Telefonszam' => $this->input->post('tel'),
			'Weboldal' => add_http($this->input->post('web'))
		);

		$this->distributor_model->save($distributor);
		redirect('/'. $this->name);
	}
}
