<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Device extends MY_Controller {

	public function __construct()
	{
		$config = array(
			'model_name' => $this->device_model_name,
			'name' => $this->device_name,
			'title' => 'Eszközök',
			'title_create' => 'Új eszköz',
			'title_modify' => 'Eszköz módosítása',
			'load_chosen' => TRUE
		);

		parent::__construct($config);
		$this->load->model($this->device_sensor_model_name);
	}

	public function get_by_sensor($sensor_id = NULL)
	{
		$data = ($sensor_id) ?
		$this->device_model->get_by_sensor_id($sensor_id) :
		$this->build_error(1, 'sensorId megadása kötelező');

		$this->send_json($data);
	}

	protected function load_edit_data()
	{
		// Load data for <select>-s
		$this->load->model($this->sensor_model_name);
		$data['sensors'] = $this->sensor_model->get_all();
		$data['error_msg'] = '';
		return $data;
	}

	public function edit($id) {
		$this->load->model($this->device_sensor_model_name);
		$data['sensors_for_device'] = $this->device_sensor_model->get_by_device_id($id);

		$data['device'] = $this->device_model->get_by_id($id);
		$this->load_edit_view($id, $data);
	}

	public function save()
	{
		$this->load->model($this->measurement_model_name);
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->form_validation->set_rules('description', 'leírás', 'required');
		$has_error = ($this->form_validation->run() === FALSE);
		$error_msg = '';

		if(!$has_error)
		{
			// Save device
			$data = array(
				'id' => $this->input->post('id'),
				'Leiras' => $this->input->post('description')
			);
			$device_id = $this->device_model->save($data);

			// Process device-sensor relations
			$selected_sensors = $this->input->post('alkatreszek[]'); //selected sensors from the edit.php form
			$selected_sensors = $selected_sensors ? $selected_sensors : array();
			$device_sensors_from_db = $this->device_sensor_model->get_by_device_id($device_id); //actual device's sensor ids

			$ids_to_delete = array();
			foreach($device_sensors_from_db as $sensor_db)
			{
				if(in_array($sensor_db->AlkatreszId, $selected_sensors)) //db:+ select:+
				{
					if(($key = array_search($sensor_db->AlkatreszId, $selected_sensors)) !== FALSE)
					{
						unset($selected_sensors[$key]);
					}
				}
				else //db:+ select:-
				{
					$measurement = $this->measurement_model->get_by_device_and_sensor($device_id, $sensor_db->AlkatreszId);
					if(empty($measurement))
					{
						array_push($ids_to_delete, $sensor_db->ssz);
					}
					else
					{
						$error_msg .= $has_error ? '</br>' : '';
						$error_msg .= '<strong>'. $measurement[0]->SzenzorNev .'</strong> alkatrész nem törölhető, mert létezik mérés ami erre a kapcsolatra mutat.';
						$has_error = TRUE;
					}
				}
			}

			// Delete existing relations which have been deleted by the user now
			if(!empty($ids_to_delete))
			{
				$this->device_sensor_model->delete($ids_to_delete);
			}

			// Create new relations which have been created by the user now
			foreach($selected_sensors as $sensor_id)
			{
				$data = array(
					'EszkozId' => $device_id,
					'AlkatreszId' => $sensor_id
				);
				$this->device_sensor_model->save($data);
			}
		}

		// Display error
		if($has_error)
		{
			$id = $this->input->post('id');

			$this->load->model($this->device_sensor_model_name);
			$data['sensors_for_device'] = $this->device_sensor_model->get_by_device_id($id);
			$data['error_msg'] = $error_msg;

			$this->load_edit_view($id, $data);
			return;
		}

		redirect('/'. $this->name);
	}
}
