<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Availability extends MY_Controller {

  public function __construct()
  {
    $config = array(
      'model_name' => $this->availability_model_name,
      'name' => $this->availability_name,
      'title' => 'Beszerezhetőség',
      'title_create' => 'Új beszerezhetőség',
      'title_modify' => 'Beszerezhetőség módosítása',
      'load_chosen' => TRUE
    );

    parent::__construct($config);
  }

  protected function load_edit_data()
  {
    $this->load_css('css/jquery-ui.min.css');
    $this->load_js('js/jquery-ui.min.js');
    // Load data for <select>-s
    $this->load->model($this->sensor_model_name);
    $this->load->model($this->distributor_model_name);

    $data['sensors'] = $this->sensor_model->get_all();
    $data['distributors'] = $this->distributor_model->get_all();
    return $data;
  }

  public function edit($id)
  {
    // Render data
    $data['availability'] = $this->availability_model->get_by_id($id);
    $this->load_edit_view($id, $data);
  }

  public function save()
  {
    // Validate data
    $this->load->library('form_validation');
    $this->form_validation->set_rules('sensor', 'Alkatrész', 'required');
    $this->form_validation->set_rules('distributor', 'Forgalmazó', 'required');
    $this->form_validation->set_rules('code', 'Árukód', 'required');
    $this->form_validation->set_rules('price', 'Ár', 'is_numeric');
    $this->form_validation->set_rules('currency', 'Pénznem', 'alpha');
    $this->form_validation->set_rules('deadline', 'Szállítási határidő', 'is_date');
    $has_error = ($this->form_validation->run() === FALSE);

    // Display error
    if($has_error)
    {
      $id = $this->input->post('id');
      $this->load_edit_view($id);
      return;
    }

    // Save and redirect
    $avail = array(
      'id' => $this->input->post('id'),
      'AlkatreszId' => $this->input->post('sensor'),
      'ForgalmazoId' => $this->input->post('distributor'),
      'Arukod' => $this->input->post('code'),
      'Ar' => $this->input->post('price'),
      'Penznem' => $this->input->post('currency'),
      'SzallitasiHatarido' => $this->input->post('deadline')
    );

    $this->availability_model->save($avail);
    redirect('/'. $this->name);
  }
}
